﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace Test_Score_List
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        // Metoda ReadScores() odczytuje z pliku TestScores.txt wyniki
        // ze sprawdzianów i umieszcza je w obiekcie scoresList. 
        private void ReadScores(List<int> scoresList)
        {
            try
            {
                // Otworzenie pliku TestScores.txt. 
                StreamReader inputFile = File.OpenText("TestScores.txt");

                // Umieszczenie zawartości pliku w obiekcie List. 
                while (!inputFile.EndOfStream)
                {
                    scoresList.Add(int.Parse(inputFile.ReadLine()));
                }

                // Zamknięcie pliku. 
                inputFile.Close();
            }
            catch (Exception ex)
            {
                // Wyświetlenie komunikatu błędu. 
                MessageBox.Show(ex.Message);
            }
        }

        // Metoda DisplayScores() wyświetla w kontrolce
        // ListBox zawartość obiektu scoresList. 
        private void DisplayScores(List<int> scoresList)
        {
            foreach (int score in scoresList)
            {
                testScoresListBox.Items.Add(score);
            }
        }

        // Metoda Average() zwraca średnią 
        // wartości w obiekcie scoresList.
        private double Average(List<int> scoresList)
        {
            int total = 0;          // Zmienna akumulatora.
            double average;         // Zmienna przechowująca średnią. 

            // Obliczenie sumy wszystkich wyników. 
            foreach (int score in scoresList)
            {
                total += score;
            }

            // Obliczenie wartości średniej wyników. 
            average = (double)total / scoresList.Count;

            // Zwrot wartości średniej. 
            return average;
        }

        // Metoda AboveAverage() zwraca liczbę wyników większych 
        // niż średni w przechowywanych w obiekcie scoresList. 
        private int AboveAverage(List<int> scoresList)
        {
            int numAbove = 0;       // Zmienna akumulatora.

            // Pobranie wartości średniej. 
            double avg = Average(scoresList);

            // Obliczenie liczby wyników większych niż średni. 
            foreach (int score in scoresList)
            {
                if (score > avg)
                {
                    numAbove++;
                }
            }

            // Zwrot liczby wyników większych niż średni. 
            return numAbove;
        }

        // Metoda BelowAverage() zwraca liczbę wyników ,niejszych
        // niż średni przechowywanych w obiekcie scoresList. 
        private int BelowAverage(List<int> scoresList)
        {
            int numBelow = 0;    // Zmienna akumulatora.

            // Pobranie wartości średniej. 
            double avg = Average(scoresList);

            // Obliczenie liczby wyników mniejszych niż średni. 
            foreach (int score in scoresList)
            {
                if (score < avg)
                {
                    numBelow++;
                }
            }

            // Zwrot liczby wyników mniejszych niż średni. 
            return numBelow;
        }

        private void getScoresButton_Click(object sender, EventArgs e)
        {
            double averageScore; // Zmienna przechowująca wynik średni.
            int numAboveAverage; // Liczba wyników większych niż średni.
            int numBelowAverage; // Liczba wyników mniejszych niż średni.

            // Utworzenie obiektu przechowującego wyniki. 
            List<int> scoresList = new List<int>();

            // Odczyt wyników z pliku i umieszczenie ich w obiekcie List. 
            ReadScores(scoresList);

            // Wyświetlenie wyników. 
            DisplayScores(scoresList);

            // Wyświetlenie obliczonej wartości średniej wyników. 
            averageScore = Average(scoresList);
            averageLabel.Text = averageScore.ToString("n1");

            // Wyświetlenie obliczonej liczby wyników większych niż średni.
            numAboveAverage = AboveAverage(scoresList);
            aboveAverageLabel.Text = numAboveAverage.ToString();

            // Wyświetlenie obliczonej liczby wyników mniejszych niż średni.
            numBelowAverage = BelowAverage(scoresList);
            belowAverageLabel.Text = numBelowAverage.ToString();
        }

        private void exitButton_Click(object sender, EventArgs e)
        {
            // Zamknięcie formularza. 
            this.Close();
        }
    }
}
